/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.config;

import dev.ftb.extendedexchange.config.ClientConfig;
import dev.ftb.extendedexchange.config.ConfigHelper;
import dev.ftb.extendedexchange.config.ServerConfig;
import java.math.BigInteger;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHolder {
    static ClientConfig client;
    static ServerConfig server;
    private static ForgeConfigSpec configClientSpec;
    private static ForgeConfigSpec configServerSpec;

    public static void init() {
        Pair clientSpec = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        client = (ClientConfig)clientSpec.getLeft();
        configClientSpec = (ForgeConfigSpec)clientSpec.getRight();
        Pair serverSpec = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        server = (ServerConfig)serverSpec.getLeft();
        configServerSpec = (ForgeConfigSpec)serverSpec.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configClientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)configServerSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHolder::onConfigChanged);
    }

    private static void onConfigChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == configClientSpec) {
            ConfigHolder.refreshClient();
        } else if (config.getSpec() == configServerSpec) {
            ConfigHolder.refreshServer();
        }
    }

    private static void refreshServer() {
        ConfigHelper.emcLinkMaxOutput = BigInteger.valueOf((Long)ConfigHelper.server().general.emcLinkMaxOutput.get());
    }

    private static void refreshClient() {
    }
}

